﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.VistaPharmacyModels;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class VistaPharmacyMedicalEducationMap
    {
        public static async Task<IQueryable<VistaPharmacyMedicalEducation>> MapVistaPharmacyMedicalEducations(List<ppms_medicaleducation> ppmsMedicalEducations,string queryType, IOrganizationService _service)
        {
            var medicalEducationList = new List<VistaPharmacyMedicalEducation> { };            
            int count = 0;
            
            foreach (var ppmsMedicalEducation in ppmsMedicalEducations)
            {
                count += 1;                         
                var medicalEduation = new VistaPharmacyMedicalEducation
                {
                    EducationName = ppmsMedicalEducation.ppms_name          
                };

                //Primary Provider NPI
                if (ppmsMedicalEducation.Attributes.ContainsKey("provider.ppms_provideridentifier") == true)
                {
                    medicalEduation.ProviderNPI = (string)ppmsMedicalEducation.GetAttributeValue<AliasedValue>("provider.ppms_provideridentifier").Value;
                }

                //Status
                if (ppmsMedicalEducation.StatusCode != null)
                    switch (ppmsMedicalEducation.StatusCode.Value)
                    {
                        case (int)ppms_medicaleducation_StatusCode.Active:
                            medicalEduation.StatusReason = MedicalEducationStatusReason.Active;
                            break;
                        case (int)ppms_medicaleducation_StatusCode.Inactive:
                            medicalEduation.StatusReason = MedicalEducationStatusReason.Inactive;
                            break;
                    }


                medicalEducationList.Add(medicalEduation);              
            }          
            var medicalEducuations = medicalEducationList.AsQueryable();
            return medicalEducuations;
        }
    }
}